/*
 * Decompiled with CFR 0.152.
 */
package gravity_edit;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Image;

public final class Util {
    private static final int MSB = 128;
    private static final int TWO_CHAR_MASK = 192;
    private static final int THREE_CHAR_MASK = 224;
    private static Object object = new Object();
    private static Random rnd = new Random();

    private Util() {
    }

    public static int getRandom(int n, int n2) {
        return n + Math.abs(rnd.nextInt()) % (n2 - n);
    }

    public static Image getImage(String string) {
        InputStream inputStream = null;
        try {
            Image image;
            inputStream = object.getClass().getResourceAsStream(string);
            Image image2 = image = Image.createImage((InputStream)inputStream);
            return image2;
        }
        catch (IOException iOException) {
            throw new RuntimeException("could not create image '" + string + "': " + iOException.toString());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String readUnicodeLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if (((n = inputStream.read()) & 0x80) == 128) {
                int n2;
                if ((n & 0xE0) == 192) {
                    n2 = inputStream.read();
                    if ((n2 & 0xC0) != 128) {
                        throw new RuntimeException("invalid second char: " + Integer.toHexString(n2));
                    }
                    n = (char)((n & 0x1F) << 6 | n2 & 0x3F);
                } else if ((n & 0xE0) == 224) {
                    n2 = inputStream.read();
                    int n3 = inputStream.read();
                    if ((n2 & 0xC0) != 128) {
                        throw new RuntimeException("invalid second char: " + Integer.toHexString(n2));
                    }
                    if ((n3 & 0xC0) != 128) {
                        throw new RuntimeException("invalid third char: " + Integer.toHexString(n3));
                    }
                    n = (char)((n & 0xF) << 12 | (n2 & 0x3F) << 6 | n3 & 0x3F);
                } else {
                    throw new RuntimeException("invalid group start: " + Integer.toHexString(n));
                }
            }
            if (n == 13) continue;
            if (n == 10) break;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }
}

